package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.custom.TareaAperturasCustomDao;
import com.ejie.ab04b.dao.custom.TramiteAperturasCustomDao;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TramiteAperturasServiceImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Service(value = "tramiteAperturasService")
public class TramiteAperturasServiceImpl implements TramiteAperturasService {

	@Autowired()
	private TramiteAperturasCustomDao tramiteAperturasDao;
	@Autowired()
	private TareaAperturasCustomDao tareaAperturasDao;

	/**
	 * Inserts a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAperturas add(TramiteAperturas tramiteAperturas) {
		return this.tramiteAperturasDao.add(tramiteAperturas);
	}

	/**
	 * Updates a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteAperturas update(TramiteAperturas tramiteAperturas) {
		return this.tramiteAperturasDao.update(tramiteAperturas);
	}

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	public TramiteAperturas find(TramiteAperturas tramiteAperturas) {
		return (TramiteAperturas) this.tramiteAperturasDao
				.vfind(tramiteAperturas);
	}

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  apertura
	 *            ComunicacionApertura
	 *  TramiteAperturas
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param apertura the apertura
	 * @return the tramite aperturas
	 */
	public TramiteAperturas findLastTramiteByTipo(Long idTipoTramite,
			ComunicacionApertura apertura) {
		return (TramiteAperturas) this.tramiteAperturasDao
				.findLastTramiteByTipo(idTipoTramite, apertura);
	}

	/**
	 * Busca un trámite y le carga su lista de tareas asociadas.
	 * 
	 *  tramiteAperturas            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	public TramiteAperturas findConTareas(TramiteAperturas tramiteAperturas) {

		TramiteAperturas tramiteAperturasAux = (TramiteAperturas) this.tramiteAperturasDao
				.vfind(tramiteAperturas);

		TareaAperturas filterTareaAperturas = new TareaAperturas();
		filterTareaAperturas.setTramiteAperturas(tramiteAperturasAux);
		List<TareaAperturas> listaTareas = this.tareaAperturasDao.vfindAll(
				filterTareaAperturas, null);

		tramiteAperturasAux.setListaTareas(listaTareas);

		return tramiteAperturasAux;
	}

	/**
	 * Deletes a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TramiteAperturas tramiteAperturas) {
		this.tramiteAperturasDao.remove(tramiteAperturas);
	}

	/**
	 * Finds a list of rows in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TramiteAperturas>
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TramiteAperturas> findAll(TramiteAperturas tramiteAperturas,
			JQGridRequestDto jqGridRequestDto) {
		return (List<TramiteAperturas>) this.tramiteAperturasDao.vfindAll(
				tramiteAperturas, jqGridRequestDto);
	}

	/**
	 * Finds a list of rows in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  List<TramiteAperturas>
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the list
	 */
	public List<TramiteAperturas> findAllConTareas(
			TramiteAperturas tramiteAperturas) {
		List<TramiteAperturas> listaTramites = (List<TramiteAperturas>) this.tramiteAperturasDao
				.vfindAll(tramiteAperturas, null);

		for (TramiteAperturas tramite : listaTramites) {
			TareaAperturas filterTareaAperturas = new TareaAperturas();
			filterTareaAperturas.setTramiteAperturas(tramite);
			List<TareaAperturas> listaTareas = this.tareaAperturasDao.vfindAll(
					filterTareaAperturas, null);

			tramite.setListaTareas(listaTareas);
		}

		return listaTramites;
	}

	/**
	 * Finds rows in the TramiteAperturas table using like.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TramiteAperturas>
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TramiteAperturas> findAllLike(
			TramiteAperturas tramiteAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<TramiteAperturas>) this.tramiteAperturasDao.findAllLike(
				tramiteAperturas, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the TramiteAperturas table.
	 * 
	 *  filterTramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<TramiteAperturas>
	 *
	 * @param filterTramiteAperturas the filter tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<TramiteAperturas> filter(
			TramiteAperturas filterTramiteAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<TramiteAperturas> listaTramiteAperturas = this.tramiteAperturasDao
				.findAllImprimirDocsAperturaLike(filterTramiteAperturas,
						jqGridRequestDto, false);
		Long recordNum = this.tramiteAperturasDao
				.findAllLikeImprimirDocsAperturaCount(
						filterTramiteAperturas != null ? filterTramiteAperturas
								: new TramiteAperturas(), false);

		return new JQGridResponseDto<TramiteAperturas>(jqGridRequestDto,
				recordNum, listaTramiteAperturas);
	}

	/**
	 * Searches rows in the TramiteAperturas table.
	 * 
	 *  filterTramiteAperturas
	 *            TramiteAperturas
	 *  searchTramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TramiteAperturas>>
	 *
	 * @param filterTramiteAperturas the filter tramite aperturas
	 * @param searchTramiteAperturas the search tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<TramiteAperturas>> search(
			TramiteAperturas filterTramiteAperturas,
			TramiteAperturas searchTramiteAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tramiteAperturasDao.search(filterTramiteAperturas,
				searchTramiteAperturas, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in TramiteAperturas table.
	 * 
	 *  filterTramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTramiteAperturas the filter tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(TramiteAperturas filterTramiteAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.tramiteAperturasDao.reorderSelection(
				filterTramiteAperturas, jqGridRequestDto, startsWith);
	}

}
